// Header File
// Created 13/03/2004; 23:04:16
//Gestion des monstres.

//Prototypes:
void ChangeMonsterSpeed (unsigned char item, unsigned short speed);
void MONSTER00_SetMove0 (unsigned char item);

unsigned char MONSTER_DEAD [13]={START_MonstersDeadSprites,
																0,
																0,
																0,
																0,
																0,
																0,
																0,
																0,
																0,
																0,
																0,
																0};
																
unsigned char MONSTER_SPRITES [13+6]={8,0,0,0,0,0,0,0,0,0,0,0,0,
																			6,0,0,0,0,0};

//Structure MONSTER
struct MONSTER {
	short xpos, ypos;																	//Coordonnes du monstre
	
	unsigned char	monster;														//Numro du monstre
	unsigned char sprite, sprite_end;									//Sprite en cours et nombre de sprites
	
	//Interruption changement de vitesse
	unsigned short speed;															//Vitesse du monstre
	unsigned char speed_value;												//Coefficient de vitesse
	unsigned short counter_value;											//Counter incrmentations
	unsigned short counter_update_monsterpos;					//Update monster pos
	
	//Mouvements prcalculs
	unsigned char Move_Index;													//Mouvement dans la liste
	unsigned char Move_Max;														//Taille maximal de la liste
		
	//Trajectoire que le monstre ralise
	char xmove, ymove;																//Dplacement
	
	BOOL dead;																				//Monstre dtruit
	
	BOOL flag_shadow;																	//Shadow																
};

struct MONSTER *Monster[45];												//Structure des monstres
static unsigned char nbrMonster=0;

#define MONSTER_ANIM										7
#define __MONSTER_ANIM_FREQUENCY				900
static unsigned short __COUNTER_MONSTER_ANIM=0;

#define MONSTER_DIR										0.8
#define __MONSTER_DIR_FREQUENCY				102
static unsigned short __COUNTER_MONSTER_DIR=0;

//Zone ou le monstre change de mouvement
#define MONSTER_ZONE_MOVE								95	

//Dplacement circulaire Monster00
const char MONSTER00_Move_x [52]={1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,-1,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0,-1, 0, 0, 0, 1, 0, 1, 1, 1, 1,1,1, 1,1,1};
const char MONSTER00_Move_y [52]={0,0,0,2,0,0,1,1,1,2,1,1,1,1,1, 1,1, 1, 1, 1, 2, 0, 0, 1, 0, 0, 0, 0, 0,-1, 0, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,0};

//Dtruit les blocs de mmoire des monstres.
void Destroy_MonsterAllocation (void)
{
	for (int i=0;i<nbrMonster;i++) free (Monster [i]);
}

//Intialise les donnes d'un monstre
void NewMonster (short x, short y, unsigned char type, unsigned short speed)
{
	//Dpassement de capacit
	if (nbrMonster==45) return;
	
	StartIntMonster=FALSE;
	
	//Alloue de la mmoire pour la Bille
	Monster [nbrMonster]=malloc (sizeof (struct MONSTER));
	
	//Coordonnes
	Monster [nbrMonster]->xpos=x;
	Monster [nbrMonster]->ypos=y;
	
	//Type
	Monster [nbrMonster]->monster=type;
	
	//Sprite de dbut
	Monster [nbrMonster]->sprite=0;
	Monster [nbrMonster]->sprite_end=MONSTER_SPRITES [type];
	Monster [nbrMonster]->flag_shadow=FALSE; 
	
	//Vitesse du monstre
	ChangeMonsterSpeed (nbrMonster, speed);
	
	//Mouvements prcalculs
	Monster [nbrMonster]->Move_Index=0;
	Monster [nbrMonster]->xmove=0; Monster [nbrMonster]->ymove=1;
	
	Monster [nbrMonster]->dead=FALSE;
	
	//Taille maximal de la liste
	if (type==0) Monster [nbrMonster]->Move_Max=52;
	
	nbrMonster++;
	StartIntMonster=TRUE;
}

//Efface une bille
void DeleteMonster (unsigned char item)
{
	//Arrte interruption
	StartIntMonster=FALSE;
	
	//Libre mmoire
	free (Monster [item]);
	
	//Dplace liste de pointeurs
	memmove ((void *)(Monster+item),(void *)(Monster+item+1),(nbrMonster-item-1)<<2);
	
	//Monstre en moins
	nbrMonster--;
	
	//Restore interruption
	StartIntMonster=TRUE;
}

//Efface toutes les Billes
void DeleteAllMonsters (void)
{
	//Parcours les Billes
	for (int i=0;i<nbrMonster;i++)
		//Efface monstre
		DeleteMonster (i--);
}

//Cration de l'animation explosion
void CREATE_ANIM_MONSTER_DEAD (unsigned char item)
{
	Monster [item]->dead=TRUE;					//Monstre dtruit
	Monster [item]->sprite=0;						//Remise  zro de l'animation
	Monster [item]->monster=MONSTER_DEAD [Monster [item]->monster];			//Sprite
	Monster [item]->sprite_end=MONSTER_SPRITES [Monster [item]->monster];	//Nombre de sprites
}

//Dessine les monstres dans le buffer ScreenBuffer
void DrawMonsters (void)
{
	//Parcours monstres
	for (int i=0;i<nbrMonster;i++)
	{
		//Shadow
		if (Monster [i]->flag_shadow)
			DrawSprite16_SHADOW (Monster [i]->xpos+3,Monster [i]->ypos+3,16,SPRITE_MONSTER [Monster [i]->monster][Monster [i]->sprite],ScreenBuffer);
		
		//Dessine sprite
		FastGraySprite16_MASK_R (Monster [i]->xpos, Monster [i]->ypos,16,SPRITE_MONSTER [Monster [i]->monster][Monster [i]->sprite],ScreenBuffer);
	}
}

//Change la vitesse d'un monstre
void ChangeMonsterSpeed (unsigned char item, unsigned short speed)
{
	//Vitesse maximum
	if (speed>200) speed=200;
	
	//Arrte interruption
	StartIntMonster=FALSE;
	
	Monster [item]->speed=speed;
	Monster [item]->speed_value=0;
	Monster [item]->counter_value=speed*32768/255;
	Monster [item]->counter_update_monsterpos=0;
	
	//Restore interruption
	StartIntMonster=TRUE;
}

//Dplacement Monstre0
void UpdateMonstersPos (void)
{
	//Parcours monstres
	for (int i=0;i<nbrMonster;i++)
	{
		//Gestion de la vitesse
		for (unsigned char j=0;j<Monster [i]->speed_value;j++)
		{
			//Monstre non mort
			if (!Monster [i]->dead)
			{
				//Mouvement Monstre00
				if (Monster [i]->monster==0)
				{
					if (Monster [i]->ypos>MONSTER_ZONE_MOVE)
						//Mouvement circulaire
						MONSTER00_SetMove0 (i);
					else 
					{
						//Mouvement vertical
						Monster [i]->xpos+=Monster [i]->speed_value*Monster [i]->xmove;
						Monster [i]->ypos+=Monster [i]->speed_value*Monster [i]->ymove;
					}
				}
			}
		}
		
		//Rinitialise vitesse
		Monster [i]->speed_value=0;
	}
}

//Mouvement dplacement monster00
void MONSTER00_SetMove0 (unsigned char item)
{
	//Type de dplacement:
	//--------------------
	//ypos++ lors d'aucuns obstacles
	//Cercle puis faible incrmentation de ypos lors de l'arriv  la zone basse du jeu. 
		
	//Effectue mouvement prcalcul
	Monster [item]->xpos+=MONSTER00_Move_x [Monster [item]->Move_Index]<<1;
	Monster [item]->ypos+=MONSTER00_Move_y [Monster [item]->Move_Index++]<<1;
	
	//Dpassement de capacite
	if (Monster [item]->Move_Index==Monster [item]->Move_Max) 
		Monster [item]->Move_Index=0;				//Modulo
}